local assets=
{
	Asset("ANIM", "anim/DMpickaxe.zip"),
	Asset("ANIM", "anim/swap_DMpickaxe.zip"),
	
	Asset("IMAGE", "images/DMpickaxe.tex"),
	Asset("ATLAS", "images/DMpickaxe.xml"),
}

--local function onfinished(inst)
--    inst:Remove()
--end

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_DMpickaxe", "swap_pickaxe")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal")
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end

local function onAttack(inst,t2,t3)
	--print("DMPA "..t3.prefab.." "..t1.prefab)
	inst.EElastAttacked = t3.prefab
end

local function OnSave(inst, data)
	if inst.EElastAttacked then
		data["EElastAttacked"] = inst.EElastAttacked
	end
end

local function OnLoad(inst, data)
    if data and data["EElastAttacked"] then
		inst.EElastAttacked = data["EElastAttacked"]
		print("DM pickaxe: "..data["EElastAttacked"])
	end
end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("pickaxe")
    anim:SetBuild("DMpickaxe")
    anim:PlayAnimation("idle")
    
    inst:AddTag("sharp")
    
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.SPEAR_DAMAGE)--(TUNING.PICK_DAMAGE *2)
	inst.components.weapon:SetOnAttack(onAttack)
    -----
    inst:AddComponent("tool")
    inst.components.tool:SetAction(ACTIONS.MINE, 2)
	inst.components.tool:SetAction(ACTIONS.HAMMER)
	inst.components.tool:SetAction(ACTIONS.DIG)
    -------
    
    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "DMpickaxe"
    inst.components.inventoryitem.atlasname = "images/DMpickaxe.xml"
    inst.components.inventoryitem:GetImage()
    inst.components.inventoryitem:GetAtlas()
    
    inst:AddComponent("equippable")

    inst.components.equippable:SetOnEquip( onequip )
    
    inst.components.equippable:SetOnUnequip( onunequip)
	
	inst.OnSave = OnSave
	inst.OnLoad = OnLoad
    
    return inst
end

return Prefab( "common/inventory/dmpickaxe", fn, assets)




